#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/script/create_internal_store.py,v $
# Version:     $RCSfile: create_internal_store.py,v $ $Revision: 1.1 $
# Copyright:   (C) 1999, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""
DBStore.py

Using the FileDevice class as a host, DBStore devices provide the
StoreImpl interface for persistent data storage.

"""

#############################################################################

import copy, os, pickle, random, sys

from   GnutOS.Exceptions         import HM_DeviceParameterError, \
                                        HM_DeviceError
from   GnutOS.Primitive          import true, nil
from   GnutOS.Soup               import Soup
from   GnutOS.VBO                import VBO
from   GnutOS.Classes            import Frame

from   GnutOS.Store              import StoreImpl, StoreException
from   GnutOS.DeviceDriver       import DeviceDriver
from   GnutOS.Device             import Device

from   GnutOS                    import FileDevice #fixme: dependency?
from   GnutOS                    import DBStore

try:
    import bsddb
except ImportError:
    print "\n\nCannot find Berkeley DB module.\n"""
    sys.exit(1)


#############################################################################

if __name__ == "__main__":
    print "Creating internal store ..."
    print

    class DummyHM:
        def __init__(self):
            return

        def register(self, file):
            self.file = file
            return
        
        def Device(self, dev_id):
            return self.file
        
    class DummyFile:
	def __init__(self, name):
	    self._host_name = name

	def HostName(self):
            #print "  DummyFile.HostName(): returning host name", self._host_name
	    return self._host_name

        def DriverName(self):
            #print "  DummyFile.DriverName(): returning driver name DummyFile"
            return "DummyFile"

        def MaxSize(self):
            return 0xffff


    ref_hm = DummyHM()
    ref_driver = DBStore.DBStoreDriver(ref_hm)

    ref_file = DummyFile("foo.db")
    ref_hm.register(ref_file)
    
    if ref_driver.ProbeDevice("dummy"):
        print "ERROR  store already exists on device.  Exiting.\n\n"
        sys.exit(1)

    ref_store = DBStore.DBStore(ref_driver, ref_file)
    ref_store.Format()
    print "- formatted blank store device."

    ref_store.Open()
    ref_store.SetName("internal")

    #-- close database
    ref_store.Close()

    print "Done."


#############################################################################
