#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# Get4Mail
#---------------------------------------------------------------------

# Revision 1.1  1997/02/22 21:20:00  dev
# Incorporated changes from Get4NetscapeMail.pl, Revision 1.5

# Revision 1.0  1997/02/22 19:00:00  dev
# Initial revision
# based on Get4NetscapeMail.pl, Revision 1.2
#

sub Get4Mail {

    select((select(STDOUT), $|=1)[$[]);

    # have you set your address in .newtonlink ?
    if ( $YourEmailAddress eq "Your.Name\@host.domain" ) {
	print "\nWARNING\n";
	if (-e "$ENV{'HOME'}/.newtonlink"){
	    print "Before sending mail you need to set the value of ";
	    print "\$YourEmailAddress\nin ".$ENV{'HOME'}."/.newtonlink";
	    print " or /etc/newtonlink.config\n";
	} else {
	    print "Before sending mail you need to set the value of ";
	    print "\$YourEmailAddress\nin \~/.newtonlink";
	    print " or /etc/newtonlink.config\n";
	}
	print "Mail fetch aborted.\n";
	return;
    }
    
    # start counter
    $EmailCounter = 0;
    # set marker
    $MailOn = "off";

    # send commands to Sloup (get "to" entries)
    &send_line (COMNEWTON, "Outbox");
    &send_line (COMNEWTON, '{state: "string", category: "string",' .
                           'toRef: [{email: "binary", name: {first: "string", last: "string"}}]}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \";\"}");

    # reset message counter
    $MessCount = 0;

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
	s/\232/oe/g; s/\212/ae/g; s/\237/ue/g; s/\247/ss/g; s/\205/Oe/g; s/\200/Ae/g; s/\206/Ue/g;
	# split into
	@Arrr = split(/;/, $_);

	# if new outbox entry
	if (($Arrr[0] eq "ready") && ($Arrr[1] eq $NewtonMailer)) {
	    #print;

	    # calculate number of to-entries
	    $ToCount[$MessCount] = ((scalar @Arrr) - 3) / 3;

	    # create string
	    $ToString[$MessCount] =  "To: ";	    
	    for ($ri = 0; $ri < $ToCount[$MessCount]; $ri++) {
		$ToString[$MessCount] = "$ToString[$MessCount]".",\n" if ($ri > 0); 
		$ToString[$MessCount] = "$ToString[$MessCount]"." \""."$Arrr[($ri*3)+2+2]"." "."$Arrr[($ri*3)+1+2]"."\" "."<$Arrr[($ri*3)+2]>";
	    }

	    #print "Message contains $ToCount[$MessCount] TO-entries :\n";
	    #print "$ToString[$MessCount]\n";
	    $MessCount++;
        }
    }

    if ($SystemType eq "IRIX") {
        close COMNEWTON;
        open (COMNEWTON, "+>$tty");
        &SetSloupBaudrate;
        printf (COMNEWTON "\n");
    }

    # send commands to Sloup (get "cc" entries)
    &send_line (COMNEWTON, "Outbox");
    &send_line (COMNEWTON, '{state: "string", category: "string",' .
                           'cc: [{email: "binary", name: {first: "string", last: "string"}}]}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \";\"}");

    # reset message counter
    $MessCount = 0;

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
	s/\232/oe/g; s/\212/ae/g; s/\237/ue/g; s/\247/ss/g; s/\205/Oe/g; s/\200/Ae/g; s/\206/Ue/g;
	# split into
	@Arrr = split(/;/, $_);

	# if new outbox entry
	if (($Arrr[0] eq "ready") && ($Arrr[1] eq $NewtonMailer)) {
	    #print;

	    # calculate number of cc-entries
	    $CCCount[$MessCount] = ((scalar @Arrr) - 3) / 3;

	    # create string
	    for ($ri = 0; $ri < $CCCount[$MessCount]; $ri++) {
		if( ($ri == 0 ) && (length( $Arrr[($ri*3)+2]) > 0)) {
                    $CCString[$MessCount] =  "CC: ";
                }
		if( length( $Arrr[($ri*3)+2]) > 0) {
	            $CCString[$MessCount] = "$CCString[$MessCount]".",\n" if ($ri > 0); 
	            $CCString[$MessCount] = "$CCString[$MessCount]"." \""."$Arrr[($ri*3)+2+2]"." "."$Arrr[($ri*3)+1+2]"."\" "."<$Arrr[($ri*3)+2]>"; 
                }
	    }

	    #print "Message contains $CCCount[$MessCount] CC-entries :\n";
	    #print "$CCString[$MessCount]\n";
	    $MessCount++;
        }
    }

    if ($SystemType eq "IRIX") {
        close COMNEWTON;
        open (COMNEWTON, "+>$tty");
        &SetSloupBaudrate;
        printf (COMNEWTON "\n");
    }


    # send commands to Sloup (get "bcc" entries)
    &send_line (COMNEWTON, "Outbox");
    &send_line (COMNEWTON, '{state: "string", category: "string",' .
                           'bcc: [{email: "binary", name: {first: "string", last: "string"}}]}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \";\"}");

    # reset message counter
    $MessCount = 0;

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
	s/\232/oe/g; s/\212/ae/g; s/\237/ue/g; s/\247/ss/g; s/\205/Oe/g; s/\200/Ae/g; s/\206/Ue/g;
	# split into
	@Arrr = split(/;/, $_);

	# if new outbox entry
	if (($Arrr[0] eq "ready") && ($Arrr[1] eq $NewtonMailer)) {

	    # calculate number of cc-entries
	    $BCCCount[$MessCount] = ((scalar @Arrr) - 3) / 3;

	    for ($ri = 0; $ri < $BCCCount[$MessCount]; $ri++) {
		if( ($ri == 0 ) && (length( $Arrr[($ri*3)+2]) > 0)) {
                    $BCCString[$MessCount] =  "BCC: ";
                }
		if( length( $Arrr[($ri*3)+2]) > 0) {
	            $BCCString[$MessCount] = "$BCCString[$MessCount]".",\n" if ($ri > 0); 
	            $BCCString[$MessCount] = "$BCCString[$MessCount]"." \""."$Arrr[($ri*3)+2+2]"." "."$Arrr[($ri*3)+1+2]"."\" "."<$Arrr[($ri*3)+2]>"; 
                }
	    }

	    #print "Message contains $BCCCount[$MessCount] BCC-entries :\n";
	    #print "$BCCString[$MessCount]\n";
	    $MessCount++;
        }
    }

    if ($SystemType eq "IRIX") {
        close COMNEWTON;
        open (COMNEWTON, "+>$tty");
        &SetSloupBaudrate;
        printf (COMNEWTON "\n");
    }

    
    # send commands to Sloup
    &send_line (COMNEWTON, "Outbox");
    &send_line (COMNEWTON, '{state: "string", category: "string", title: "string", dateStr: "string",' .
                           'fromName: "string", text: "string"}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \"\t\"}");

    # reset message counter
    $MessCount = 0;

    while (($_ = &receive_line(COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
	s/\232/oe/g; s/\212/ae/g; s/\237/ue/g; s/\247/ss/g; s/\205/Oe/g; s/\200/Ae/g; s/\206/Ue/g;
	# split into
	($Estate, $Ecategory, $Etitle, $EdateStr, $EfromName, $Ebody) = split(/\t/, $_, 20);

	# if new outbox entry
	if (defined ($Estate) && ($Estate eq "ready")) {

	    if (defined ($Ecategory) && ($Ecategory eq $NewtonMailer)) {

		# set marker
		$MailOn = "on";

                # Open pipe to mailer
                open (MAIL, "| $MailCommand")  || die "Can't open File : $!\n";

		# print to file
		#printf MAIL "Message-ID: <>\n";
		printf MAIL "From: $EfromName \<$YourEmailAddress\>\n";
		printf MAIL "Reply-To: $EfromName \<$YourEmailAddress\>\n";
		printf MAIL "Organization: $YourOrganisation\n";
		printf MAIL "X-Mailer: Newton eWorld mail (via newtonlink/Linux)\n";
		printf MAIL "MIME-Version: 1.0\n";
		printf MAIL "$ToString[$MessCount]\n";
		printf MAIL "$CCString[$MessCount]\n" if ( length ($CCString[$MessCount]) > 0); 
		printf MAIL "$BCCString[$MessCount]\n" if ( length ($BCCString[$MessCount]) > 0);
		printf MAIL "Subject: $Etitle\n";
		printf MAIL "Content-Type: text/plain; charset=us-ascii\n";
		printf MAIL "Content-Transfer-Encoding: 7bit\n\n";
		printf MAIL "\n$Ebody\n";

		$MessCount++;
		# Print sign to stdout
		print "#";
		$EmailCounter++;
	
	    } else {
		# reset marker
		$MailOn = "off";
    # close file
     close (MAIL);
	    }

	# if not new outbox entry
	} elsif ($MailOn eq "on") {
	    print MAIL;
	}

    }

    # close file
    close (MAIL);
    # print to stdout
    print ("\n$EmailCounter eWorld emails transfered");
}

1;
