#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# Get4NetscapeAddress-book
#---------------------------------------------------------------------

# $Log: Get4NetscapeAddressbook.pl,v $
# Revision 1.12  1998/09/02 13:55:21  kalli
# *** empty log message ***
#
# Revision 1.11  1998/03/07 14:15:58  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.10  1998/01/11 16:23:22  kalli
# Erweiterung von Gerald Hofer fuer IRIX :
# Es wird zwischendurch ein Reopen auf COMNEWTON gemacht.
#
# Revision 1.9  1997/12/06 17:14:45  kalli
# Umstellung auf sloup
#
# Revision 1.8  1997/09/28 09:52:56  kalli
# Aenderung von Andrew :
# Select-Statement
#
# Revision 1.7  1997/05/31 09:48:01  kalli
# Unterscheidung limited/unlimited repeat meetings
#
# Revision 1.6  1997/05/30 13:21:54  kalli
# Netscape Communicator addressbook file wird vorher gesichert
#
# Revision 1.5  1997/05/29 20:55:29  kalli
# Email groups dazu
#
# Revision 1.4  1997/03/27 19:35:38  kalli
# Andrew dazu
#
# Revision 1.3  1997/02/23 15:05:36  kalli
# Frank dazu
#
# Revision 1.2  1997/02/22 16:55:35  kalli
# GPL dazu
#
# Revision 1.1  1997/02/22 16:53:26  kalli
# Initial revision
#

sub Get4NetscapeAddressbook {

    # Get actual Newton cards
    &GetCards;

    # start counter
    $NsAn = 0;
    $NsGr = 0;

    # save old Netscape Navigator Addressbook file
    if (-e "$NetscapeNavigatorAddressbookFile") {
	rename ("$NetscapeNavigatorAddressbookFile", "$NetscapeNavigatorAddressbookFile.bak");
    }

    # save old Netscape Communicator Addressbook file
    if (-e "$NetscapeCommunicatorAddressbookFile") {
	rename ("$NetscapeCommunicatorAddressbookFile", "$NetscapeCommunicatorAddressbookFile.bak");
    }

    # Open Newtonlink cards file
    open (NLCARDFILE, "$NLCardsFile")  || die "Can't open File : $!\n";

    # Open Navigator addressbook file
    open (NSAFILE, ">> $NetscapeNavigatorAddressbookFile")  || die "Can't open File : $!\n";

    # print to stdout
    printf "Writing Navigator addressbook file $NetscapeNavigatorAddressbookFile ...\n";
    
    while (<NLCARDFILE>) {

        ($Cardclass, $CardlastName, $CardfirstName, $Cardhonorific, $Cardaddress, $Cardcountry, $Cardpostal_code,
         $Cardcity, $Cardbday, $CardhomePhone, $CardworkPhone, $CardfaxPhone, $Cardemail, $Cardcompany) = split(/;/, $_, 20);

        if ( ($Cardclass eq "company") || ($Cardclass eq "person") || ($Cardclass eq "owner") ) {

            if ($Cardemail ne "") {
	        $NsPersonAddressCounter++;
	        # save to memory
	        $NsAdrArr[$NsAn++] = "$CardlastName\t$CardfirstName\t$Cardemail";
            }
        }
    }

    # write addressbook header
    printf NSAFILE "<!DOCTYPE NETSCAPE-Addressbook-file-1>\n";
    printf NSAFILE "<!-- This is an automatically generated file by newtonlink.\n";
    printf NSAFILE "It will be read and overwritten.\n";
    printf NSAFILE "Do Not Edit! -->\n";
    printf NSAFILE "<TITLE>My Address book generated by Newtonlink</TITLE>\n";
    printf NSAFILE "<H1>My Address book generated by Newtonlink</H1>\n\n";
    printf NSAFILE "<DL><p>\n";

    # sort entrys
    @NsAdrArrSorted = sort @NsAdrArr;

    for ($Bi = 0; $Bi < $NsAn; $Bi++) {

	# split into
	($NsBlastName, $NsBfirstName, $NsBemail) = split(/\t/, $NsAdrArrSorted[$Bi], 20);
	# replace German Umlaute (not allowed in names)
	$NsBlastName =~ s//oe/g;
	$NsBlastName =~ s//ae/g;
	$NsBlastName =~ s//ue/g;
	$NsBlastName =~ s//ss/g;
	$NsBlastName =~ s//Oe/g;
	$NsBlastName =~ s//Ae/g;
	$NsBlastName =~ s//Ue/g;
	$NsBfirstName =~ s//oe/g;
	$NsBfirstName =~ s//ae/g;
	$NsBfirstName =~ s//ue/g;
	$NsBfirstName =~ s//ss/g;
	$NsBfirstName =~ s//Oe/g;
	$NsBfirstName =~ s//Ae/g;
	$NsBfirstName =~ s//Ue/g;
	# lowercase nickname
	$NsBnickname = $NsBfirstName;
	$NsBnickname =~ /.{2,}/;
	$NsBnickname = lc "$NsBlastName$NsBnickname";
	# substitude blanks
	$NsBnickname =~ s/ //g;
	# replace German Umlaute (not allowed in nicknames)
	$NsBnickname =~ s//oe/g;
	$NsBnickname =~ s//ae/g;
	$NsBnickname =~ s//ue/g;
	$NsBnickname =~ s//ss/g;
	$NsBnickname =~ s//Oe/g;
	$NsBnickname =~ s//Ae/g;
	$NsBnickname =~ s//Ue/g;
	# write to addressbook file
	printf NSAFILE "    <DT><A HREF=\"mailto:$NsBemail\" ALIASID=\"$Bi\" NICKNAME=\"$NsBnickname\">$NsBlastName, $NsBfirstName</A>\n";
    }

    # close file
    close (NLCARDFILE);
    # Reopen Newtonlink cards file
    open (NLCARDFILE, "$NLCardsFile")  || die "Can't open File : $!\n";

    while (<NLCARDFILE>) {

	if ($_ ne "\n") {

	    # split into
	    @Arre = split(/;/, $_);

	    # if group entry
	    if ($Arre[0] eq "group") {

		# calculate number of email addresses in group
		$GroupAdrCount = (scalar @Arre) - 3;

		# lowercase group nickname
		$NsGnickname = lc "$Arre[1]";
		# substitude blanks
		$NsGnickname =~ s/ //g;
		# replace German Umlaute (not allowed in nicknames)
		$NsGnickname =~ s//oe/g;
		$NsGnickname =~ s//ae/g;
		$NsGnickname =~ s//ue/g;
		$NsGnickname =~ s//ss/g;
		$NsGnickname =~ s//Oe/g;
		$NsGnickname =~ s//Ae/g;
		$NsGnickname =~ s//Ue/g;

		# write addressbook group header
		printf NSAFILE "    <DT><H3 NICKNAME=\"$NsGnickname\">$Arre[1]</H3>\n";
		printf NSAFILE "    <DL><p>\n";

		# write group to addressbook file
		for ($Bnf = 0; $Bnf < $GroupAdrCount; $Bnf++) {

		    # look for email address in array
		    $EmailAdrFound = 0;
		    for ($Biz = 0; $Biz < ($NsPersonAddressCounter + $NsCompanyAddressCounter); $Biz++) {

			# split into
			($NsAlastName, $NsAfirstName, $NsAemail) = split(/\t/, $NsAdrArrSorted[$Biz], 20);

			# replace German Umlaute (not allowed in names)
			$NsAlastName =~ s//oe/g;
			$NsAlastName =~ s//ae/g;
			$NsAlastName =~ s//ue/g;
			$NsAlastName =~ s//ss/g;
			$NsAlastName =~ s//Oe/g;
			$NsAlastName =~ s//Ae/g;
			$NsAlastName =~ s//Ue/g;
			$NsAfirstName =~ s//oe/g;
			$NsAfirstName =~ s//ae/g;
			$NsAfirstName =~ s//ue/g;
			$NsAfirstName =~ s//ss/g;
			$NsAfirstName =~ s//Oe/g;
			$NsAfirstName =~ s//Ae/g;
			$NsAfirstName =~ s//Ue/g;

			if ("$NsAemail" eq "$Arre[$Bnf+2]") {
			    printf NSAFILE "        <DT><A HREF=\"mailto:$Arre[$Bnf+2]\" ALIASOF=\"$Biz\">$NsAlastName, $NsAfirstName</A>\n";
			    $EmailAdrFound++;			    
			}
		    }

		    # print error message if address not found in array
		    if ($EmailAdrFound == 0) {
			printf "\nError : Address $Arre[$Bnf+2] not found in group $Arre[1] !";
		    }
	        }

		# write addressbook group footer
		printf NSAFILE "    </DL><p>\n";
	    }
	}

    }


    # write addressbook footer
    printf NSAFILE "</DL><p>\n";

    # close files
    close (NSAFILE);
    close (NLCARDFILE);
}

1;


