#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# GetPackage
#---------------------------------------------------------------------

# $Log: GetPackage.pl,v $
# Revision 1.6  1998/03/06 23:37:18  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.5  1997/12/06 17:22:49  kalli
# Umstellung auf Sloup
#
# Revision 1.4  1997/09/28 10:00:34  kalli
# Aenderung von Andrew :
# Select-Statement
#
# Revision 1.3  1997/03/27 19:41:31  kalli
# Andrew dazu
#
# Revision 1.2  1997/03/06 18:51:31  kalli
# Erste Version lauffaehig
#
# Revision 1.1  1997/03/04 21:04:33  kalli
# Initial revision
#

sub GetPackage {

    select((select(STDOUT), $|=1)[$[]);
    
    # open Newton package file
    open (PSFILE, "> $PackageFileName")  || die "Can't open File : $!\n";
    binmode PSFILE;
    # set marker
    $FirstLine = 0;

    # send commands to Sloup
    &send_line (COMNEWTON, "\nPackage");
    &send_line (COMNEWTON, "{packageName: \"$PackageName\", packageEntry: \"binary:packageEntry\"}"); 
    &send_line (COMNEWTON, "DUMP!");

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# dont write first line
	if ($FirstLine == 0) {
	  $FirstLine++;
	  
	} else {

	  # Print sign to STDOUT
	  print "#";

	  # replace last "\\n in line"
	  s/\n//g; s/\\//g;

	  # calculate # of chars in line
	  $Ccount = length ($_);
	  #printf ("No of chars : $Ccount\n");

	  # split into separate chars
	  @a = split (/ */, $_);
	  # put every two chars together
	  for ($hi = 0; $hi < $Ccount; $hi++) {
	    $b[$hi]  = $a[$hi*2].$a[($hi*2)+1];
	  }

	  # write binary chars to Newton package file
	  for ($hi = 0; $hi < $Ccount/2; $hi++) {
	    printf (PSFILE "%c", hex ($b[$hi]));
	  }
	}
    }

    # close file
    close (PSFILE);
}

1;

