#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# SetSloupBaudrate
#---------------------------------------------------------------------

# $Log: SetSloupBaudRate.pl,v $
# Revision 1.18  1998/04/10 15:10:59  kalli
# Aenderungen von Mark Bowyer
#
# Revision 1.17  1998/04/03 21:19:19  kalli
# Neuer Init-String fuer Solaris lt. Mark Bowyer
#
# Revision 1.16  1998/03/12 20:41:02  kalli
# XonXoff Protokoll bei OS-2 dazu
#
# Revision 1.15  1998/03/07 16:55:51  kalli
# OS/2 String nach OS-2 geaendert
#
# Revision 1.14  1998/03/06 23:21:48  kalli
# Option OS-2 dazu
#
# Revision 1.13  1997/12/15 09:25:03  kalli
# OSF1 option vorbereitet
#
# Revision 1.12  1997/12/06 17:05:40  kalli
# Umstellung auf Sloup
#
# Revision 1.11  1997/11/29 16:46:08  kalli
# Aenderungen am Solaris-Init-String nach Mark Bowyer
#
# Revision 1.10  1997/09/21 19:32:28  kalli
# Init-Strings fuer SunOS eingefuegt.
# Waren bislang nicht drin.
#
# Revision 1.9  1997/07/15 19:43:00  kalli
# Aenderung in HP-UX Init-String von Roland.
#
# Revision 1.8  1997/07/12 19:11:54  kalli
# Aenderungen der Struktur :
# Erweiterung fuer HP-UX nach Angaben von Roland Tanglao
#
# Revision 1.7  1997/05/28 19:22:40  kalli
# Aenderungen von Gerald Hofer fuer IRIX
#
# Revision 1.6  1997/05/24 15:28:05  kalli
# Aenderungen fuer IRIX-Version von Gerald Hofer
#
# Revision 1.5  1997/03/27 19:49:02  kalli
# Andrew dazu
#
# Revision 1.4  1997/02/23 15:16:08  kalli
# Frank dazu
#
# Revision 1.3  1997/02/22 17:05:06  kalli
# GPL dazu
#
# Revision 1.2  1997/02/19 20:49:41  kalli
# Anweisung stty sane < /dev/newton auf Anraten von
# Frank Scholz <dev@artus.pf.bawue.de> aufgenommen
#
# Revision 1.1  1996/11/24 19:15:40  kalli
# Initial revision
#

sub SetSloupBaudrate {

    #---- for HP-UX ----------------------------------------------------

    if ($SystemType eq "HP-UX") {

	system "stty sane < $tty";

        if (($SloupBaudrate eq "57600") || ($SloupBaudrate eq "38400") ||
            ($SloupBaudrate eq "19200") || ($SloupBaudrate eq "9600")) {
            system "stty cs8 $SloupBaudrate -echo ignbrk -isig -icanon -iexten ixoff ixon -icrnl -istrip igncr -echoe -echok tabs < $tty";

	} else {
	    printf "Exit - wrong Sloup baudrate selected\n";
	    exit;
	}
    }

    #---- for IRIX  ----------------------------------------------------

    if ($SystemType eq "IRIX") {

	system "stty -echo ignbrk -isig -icanon -iexten ixoff ixany -icrnl -istrip igncr -echoe -echok -echoke -echoctl tabs < $tty";

	if (($SloupBaudrate eq "38400") || ($SloupBaudrate eq "19200") || ($SloupBaudrate eq "9600")) {
	    system "stty $SloupBaudrate < $tty";

	} else {
	    printf "Exit - wrong Sloup baudrate selected\n";
	    exit;
	}
    }

    #---- for OSF1  ----------------------------------------------------

    if ($SystemType eq "OSF1") {

	system "";

    }


    #---- for Solaris  --------------------------------------------------

    if ($SystemType eq "SunOS") {

        system "";

        if (($SloupBaudrate eq "38400") || ($SloupBaudrate eq "19200") || ($SloupBaudrate eq "9600")) {

            system "stty cs8 $SloupBaudrate -echo ignbrk -isig -icanon -iexten ixoff ixany onlcr icrnl -istrip -igncr -echoe -echok -parenb tabs < $tty";

        } else {
            printf "Exit - wrong Sloup baudrate selected\n";
            exit;
        }
    }


    #---- for Linux  ----------------------------------------------------

    if ($SystemType eq "Linux") {

	system "stty sane < $tty";

	if ($SloupBaudrate eq "115200") {
	    system "setserial $tty spd_vhi";
	    system "stty 38400 < $tty";
	} elsif ($SloupBaudrate eq "57600") {
	    system "setserial $tty spd_hi";
	    system "stty 38400 < $tty";
	} elsif ($SloupBaudrate eq "38400") {
	    system "setserial $tty spd_normal";
	    system "stty 38400 < $tty";
	} elsif ($SloupBaudrate eq "19200") {
	    system "setserial $tty spd_normal";
	    system "stty 19200 < $tty";
	} elsif ($SloupBaudrate eq "9600") {
	    system "setserial $tty spd_normal";
	    system "stty 9600 < $tty";
	} else {
	    printf "Exit - wrong Sloup baudrate selected\n";
	    exit;
	}
    }
    #---- for OS/2  -----------------------------------------------------

    if ($SystemType eq "OS-2") {

        system "cmd /c mode $tty:$SloupBaudrate,n,8,1,XON=ON";
    }
}

1;
