#!S_WISHBINARY_S
#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================



# $Id: tknl.tcl,v 1.13 1998/09/06 10:44:31 reinhold Exp $
# $Author: reinhold $
# $Date: 1998/09/06 10:44:31 $
# $Revision: 1.13 $
# $Log: tknl.tcl,v $
# Revision 1.13  1998/09/06 10:44:31  reinhold
# Letzte Aenderungen an doc Files fuer Version 1.29
#
# Revision 1.12  1998/09/02 13:58:05  kalli
# *** empty log message ***
#
# Revision 1.11  1998/03/27 20:43:57  kalli
# Aufruf Online-Help jetzt per newtonlink -onlinehelp
#
# Revision 1.10  1998/03/16 15:03:04  kalli
# Last version for 1.27
#
# Revision 1.9  1998/03/06 19:58:30  kalli
# Option -lpkg dazu
# Optik veraendert
#
# Revision 1.8  1998/03/02 21:20:48  kalli
# Aenderungen von Peter W : Button-Helpline
# Option -kjots dazu
#
# Revision 1.6  1997/12/17 12:26:54  kalli
# Option webadr dazugefuegt
#
# Revision 1.5  1997/12/17 09:36:00  kalli
# Aenderungen wg. neuer Installationsroutine
#
# Revision 1.4  1997/12/16 09:06:38  kalli
# Icon dazugefuegt
#
# Revision 1.3  1997/12/06 17:10:08  kalli
# Umstellung auf Sloup
#
# Revision 1.2  1997/11/18 18:48:30  kalli
# Option xfadr dazu
#
# Revision 0.56  1997/09/15 09:33:43  andrew
# Fixed a bug in proc Runf
# Unbuffered read from the pipe now works Hurray.
# Now we have a simular output as in the commandline
# version. Hurray Hurray
#
# Revision 0.55  1997/09/06 15:16:36  andrew
# Help now works
# changed name of tknl.gif to about.gif in the "About Box"
# Hopefully a candidate to release
#
# Revision 0.54  1997/09/05 08:55:16  andrew
# Fixed a typo, added a nonmodal fileselection box
# this file selction Box uses the standard tk_fileOpenBox. This makes
# it more portable amongst platforms (e.g. Windows arrghh)
#
# Revision 0.53  1997/09/03 19:18:10  andrew
# Bug fixes, mainly typos or mishaps
#
# Revision 0.52  1997/09/02 21:20:12  andrew
# changed the about box, now uses a gif
# therefore it is not modal anymore (should be changed)
#
# Revision 0.51  1997/09/02 12:22:28  andrew
# enable and disable of buttons for options that take a file
#
# Revision 0.5  1997/09/02 12:18:24  andrew
# Many changes:
# - added comments
# - added stadard GPL header
# - enable and disable menus and buttons when newtonlink is
# runnung to prevent further user interaction
# - set the cursur to watch when newtonlink is busy
# - added many spelling mistakes in this log
#
# Revision 0.1  1997/09/01 07:56:08  andrew
# initial version
#

# TK Newtonlink
# A TK interface for Newtonlink
# Code shamelessly stolen from Brent Welch
# version 0.1
global PREFIX, BROWSER, HELPDOC

set PREFIX "S_NEWTONLINK_INSTALLDIR_S"
set HELPDOC "$PREFIX/doc/newtonlink-doc-en.html" 

##################################################
#                                                #
#  Set the some variables concerning the gifs    #
#  and commadline options of Newtonlink          #
#                                                #
##################################################

wm iconbitmap . @$PREFIX/newtonlink.xbm

set quit_img [image create photo\
	-file $PREFIX/icons/exit.gif -format gif]

set update -update
set update_img [image create photo \
	-file $PREFIX/icons/update.gif -format gif]

set fax -fax
set fax_img [image create photo \
	-file $PREFIX/icons/fax.gif -format gif]

set pr -pr
set print_img [image create photo \
	-file $PREFIX/icons/print.gif]

set plan -plan
set plan_img [image create photo \
	-file $PREFIX/icons/Plan.gif -format gif]

set xrolo -xrolo
set xrolo_img [image create photo \
	-file $PREFIX/icons/xrolodex.gif -format gif]

set ksendfax -ksendfax
set ksendfax_img [image create photo \
	-file $PREFIX/icons/ksendfax.gif -format gif]

set adr -adr
set adr_img [image create photo \
	-file $PREFIX/icons/addressbook.gif -format gif]

set nsmail -nsmail
set nsmail_img [image create photo \
	-file $PREFIX/icons/NetscapeMail.gif -format gif]

set nsadr -nsadr
set nsadr_img [image create photo \
	-file $PREFIX/icons/NetscapeAddressbook.gif -format gif]

set webadr -webadr
set webadr_img [image create photo \
	-file $PREFIX/icons/webaddress.gif -format gif]

set xfadr -xfadr
set xfadr_img [image create photo \
	-file $PREFIX/icons/XfmailAddressbook.gif -format gif]
	
set kjots -kjots
set kjots_img [image create photo \
	-file $PREFIX/icons/kjots.gif -format gif]
			
set mail -mail
set mail_img [image create photo \
	-file $PREFIX/icons/mail.gif -format gif]
	
set inst -inst
set inst_img [image create photo \
	-file $PREFIX/icons/install.gif -format gif]

set lpkg -lpkg
set lpkg_img [image create photo \
	-file $PREFIX/icons/lpkg.gif -format gif]	

set onlinehelp -onlinehelp
set help_img [image create photo \
	-file $PREFIX/icons/help.gif -format gif]
	
set getpnam -getpnam
set getpnam_img [image create photo \
	-file $PREFIX/icons/getpnam.gif -format gif]
set getpkg -getpkg

set send -send
set send_img [image create photo \
	-file $PREFIX/icons/send.gif -format gif]
	

##################################################
#                                                #
#  create the main window                        #
#                                                #
##################################################

# Set title and allow window resizing.
wm title . {Newtonlink}

##################################################
#                                                #
#  Crate the menubar                             #
#                                                #
##################################################

frame .menubar -relief raised
pack .menubar -fill x

##################################################
#                                                #
#  Create the "File" menu                        #
#                                                #
##################################################

menubutton .menubar.filem -text File -menu .menubar.filem.menu -underline 0 
set m [menu .menubar.filem.menu]
#$m add command -label Preferences -underline 0 -command SelectPreferences
$m add command -label Preferences -underline 0 -command notImplementedBox
$m add command -label Quit  -underline 0 -command exit

##################################################
#                                                #
#  Create the "Update" menu                      #
#                                                #
##################################################

menubutton .menubar.update -text Update -menu .menubar.update.menu -underline 0
set m [menu .menubar.update.menu]
$m add command -label {Update all} -command {Run $update}

##################################################
#                                                #
#  Create the "Cards" menu                       #
#                                                #
##################################################

menubutton .menubar.cards -text Cards -menu .menubar.cards.menu -underline 0
set mnl [menu .menubar.cards.menu]
$mnl add command -label {Cards -> Addressbook} -command {Run $adr} -underline 0
$mnl add command -label {Cards -> Netscape Addressbook} -command {Run $nsadr} -underline 0
$mnl add command -label {Cards -> Xfmail Addressbook} -command {Run $xfadr} -underline 0
$mnl add command -label {Cards -> WebAddress} -command {Run $webadr} -underline 0
$mnl add command -label {Cards -> Ksendfax} -command {Run $ksendfax} -underline 0

##################################################
#                                                #
#  Create the "Notes" menu                       #
#                                                #
##################################################

menubutton .menubar.notes -text Notes -menu .menubar.notes.menu -underline 0
set mnl [menu .menubar.notes.menu]
$mnl add command -label {Notes -> Xrolodex} -command {Run $xrolo}
$mnl add command -label {Notes -> Kjots} -command {Run $kjots}

##################################################
#                                                #
#  Create the "Dates" menu                       #
#                                                #
##################################################

menubutton .menubar.dates -text Dates -menu .menubar.dates.menu -underline 0
set mnl [menu .menubar.dates.menu]
$mnl add command -label {Dates -> Plan} -command {Run $plan}

##################################################
#                                                #
#  Create the "Outbox" menu                       #
#                                                #
##################################################

menubutton .menubar.outbox -text Outbox -menu .menubar.outbox.menu -underline 0
set mnl [menu .menubar.outbox.menu]
$mnl add command -label {Outbox -> Fax} -command {Run $fax}
$mnl add command -label {Outbox -> Print} -command {Run $pr}

##################################################
#                                                #
#  Create the "Mail" menu                       #
#                                                #
##################################################

menubutton .menubar.mail -text Mail -menu .menubar.mail.menu -underline 0
set mnl [menu .menubar.mail.menu]
$mnl add command -label {Mail -> Netscape Mail} -command {Run $nsmail}
$mnl add command -label {Mail -> Sendmail} -command {Run $mail}

##################################################
#                                                #
#  Create the "Install" menu                     #
#                                                #
##################################################

menubutton .menubar.install -text Install -menu .menubar.install.menu -underline 0
set mnl [menu .menubar.install.menu]
$mnl add command -label {Install Package...} -command {Runf $inst}
$mnl add command -label {Install Package (using lpkg)...} -command {Runf $lpkg}

##################################################
#                                                #
#  Create the "Misc" menu                        #
#                                                #
##################################################

menubutton .menubar.misc -text Misc -menu .menubar.misc.menu -underline 1
set mnl [menu .menubar.misc.menu]
$mnl add command -label {Get Package Names} -command {Run $getpnam} -underline 12
#$mnl add command -label {Get Package...} -command getpackage -underline 4
$mnl add command -label {Get Package...} -command notImplementedBox -underline 4
$mnl add command -label {Send file...} -command {Runf $send} -underline 0

##################################################
#                                                #
#  Create the "Help" menu                        #
#                                                #
##################################################

menubutton .menubar.helpm -text Help -menu .menubar.helpm.menu -underline 0
set m [menu .menubar.helpm.menu]
$m add command -label "Help..." -command {Run $onlinehelp} -underline 0
$m add command -label "About..." -command aboutBox -underline 0

pack .menubar.filem .menubar.update -side left
pack .menubar.filem .menubar.cards -side left
pack .menubar.filem .menubar.notes -side left
pack .menubar.filem .menubar.dates -side left
pack .menubar.filem .menubar.outbox -side left
pack .menubar.filem .menubar.mail -side left
pack .menubar.filem .menubar.install -side left
pack .menubar.filem .menubar.misc -side left
pack .menubar.helpm -side right

##################################################
#                                                #
#  Create the top frame for buttons and entry.	 #		
#                                                #
##################################################

frame .top -borderwidth 1
pack .top -side top -fill x

##################################################
#                                                #
#  Create the command buttons for the top row    #
#                                                #
##################################################


button .top.nsadr -text "NsAddr" -image $nsadr_img \
		-width 20 -height 20 -command {Run $nsadr}
bind .top.nsadr <Motion> {
	.hintline.status configure -text "Get Newton card entrys for Netscape email addressbook"
}
bind .top.nsadr <Leave> {
	.hintline.status configure -text ""
}

button .top.webadr -text "WebAddr" -image $webadr_img \
		-width 20 -height 20 -command {Run $webadr}
bind .top.webadr <Motion> {
	.hintline.status configure -text "Get Newton cards for WebAddress files"
}
bind .top.webadr <Leave> {
	.hintline.status configure -text ""
}

button .top.update -text "Update" -image $update_img \
		-width 20 -height 20 -command {Run $update}
bind .top.update <Motion> {
	.hintline.status configure -text "Update all selected applications"
}
bind .top.update <Leave> {
	.hintline.status configure -text ""
}


button .top.nsmail -text "NsMail" -image $nsmail_img \
		-width 20 -height 20 -command {Run $nsmail}
bind .top.nsmail <Motion> {
	.hintline.status configure -text "Get Newton outbox entrys for Netscape email"
}
bind .top.nsmail <Leave> {
	.hintline.status configure -text ""
}
		
button .top.adr -text "Address" -image $adr_img \
		-width 20 -height 20 -command {Run $adr}
bind .top.adr <Motion> {
	.hintline.status configure -text "Get Newton cards for Addressbook file"
}
bind .top.adr <Leave> {
	.hintline.status configure -text ""
}

button .top.ksendfax -text "Ksendfax" -image $ksendfax_img \
		-width 20 -height 20 -command {Run $ksendfax}
bind .top.ksendfax <Motion> {
	.hintline.status configure -text "Get Newton cards for Ksendfax phonebook"
}
bind .top.ksendfax <Leave> {
	.hintline.status configure -text ""
}
		
button .top.xrolo -text "Xrolo" -image $xrolo_img \
		-width 20 -height 20 -command {Run $xrolo}
bind .top.xrolo <Motion> {
	.hintline.status configure -text "Get Newton notes for Xrolodex file"
}
bind .top.xrolo <Leave> {
	.hintline.status configure -text ""
}
		
button .top.plan  -text "Plan" -image $plan_img \
		-width 20 -height 20 -command {Run $plan}
bind .top.plan <Motion> {
	.hintline.status configure -text "Get Newton dates for Plan file"
}
bind .top.plan <Leave> {
	.hintline.status configure -text ""
}

button .top.print -text "Print" -image $print_img \
		-width 20 -height 20 -command {Run $pr}
bind .top.print <Motion> {
	.hintline.status configure -text "Get Newton outbox entrys for printing"
}
bind .top.print <Leave> {
	.hintline.status configure -text ""
}

button .top.fax -text "Fax" -image $fax_img \
		-width 20 -height 20 -command {Run $fax}
bind .top.fax <Motion> {
	.hintline.status configure -text "Get Newton outbox entrys for faxing"
}
bind .top.fax <Leave> {
	.hintline.status configure -text ""
}

button .top.kjots -text "Kjots" -image $kjots_img \
		-width 20 -height 20 -command {Run $kjots}
bind .top.kjots <Motion> {
	.hintline.status configure -text "Get Newton notes for Kjots file"
}
button .top.xfadr -text "XfAddr" -image $xfadr_img \
		-width 20 -height 20 -command {Run $xfadr}
bind .top.xfadr <Motion> {
	.hintline.status configure -text "Get Newton card entrys for Xfmail addressbook"
}
bind .top.xfadr <Leave> {
	.hintline.status configure -text ""
}

button .top.send -text "Send file" -image $send_img \
		-width 20 -height 20 -command {Runf $send}
bind .top.send <Motion> {
	.hintline.status configure -text "Send file to Newton"
}
bind .top.send <Leave> {
	.hintline.status configure -text ""
}

button .top.getpnam -text "Get Packackage Names" -image $getpnam_img \
		-width 20 -height 20 -command {Run $getpnam}
bind .top.getpnam <Motion> {
	.hintline.status configure -text "Get Newton package names"
}
bind .top.getpnam <Leave> {
	.hintline.status configure -text ""
}

button .top.mail -text "Mail" -image $mail_img \
		-width 20 -height 20 -command {Run $mail}
bind .top.mail <Motion> {
	.hintline.status configure -text "Get Newton outbox entrys for email"
}
bind .top.mail <Leave> {
	.hintline.status configure -text ""
}

button .top.inst -text "Install" -image $inst_img \
		-width 20 -height 20 -command {Runf $inst}
bind .top.inst <Motion> {
	.hintline.status configure -text "Install Newton package"
}
bind .top.inst <Leave> {
	.hintline.status configure -text ""
}

button .top.lpkg -text "Lpkg" -image $lpkg_img \
		-width 20 -height 20 -command {Runf $lpkg}
bind .top.lpkg <Motion> {
	.hintline.status configure -text "Install Newton package (using lpkg)"
}
bind .top.lpkg <Leave> {
	.hintline.status configure -text ""
}


button .top.help -text "Help" -image $help_img \
		-width 20 -height 20 -command {Run $onlinehelp}
bind .top.help <Motion> {
	.hintline.status configure -text "Get help for Newtonlink"
}
bind .top.help <Leave> {
	.hintline.status configure -text ""
}

button .top.quit -text "Quit" -image $quit_img \
		-width 20 -height 20 -command exit
bind .top.quit <Motion> {
	.hintline.status configure -text "Quit Newtonlink"
}
bind .top.quit <Leave> {
	.hintline.status configure -text ""
}

pack \
        .top.update \
	.top.adr \
	.top.nsadr \
	.top.xfadr \
	.top.webadr \
        .top.ksendfax \
	.top.xrolo \
	.top.kjots \
	.top.plan \
	.top.fax \
	.top.print \
	.top.nsmail \
	.top.mail \
	.top.inst \
	.top.lpkg \
	.top.getpnam \
	.top.send \
	.top.help \
	.top.quit \
	-side left

##################################################
#                                                #
#  Create a text widget to log the output        #
#                                                #
##################################################

frame .t
set log [text .t.log -width 80 -height 20 \
	-borderwidth 2 -relief flat -bg black -fg white -setgrid true\
	-yscrollcommand {.t.scroll set}]
scrollbar .t.scroll -command {.t.log yview}
pack .t.scroll -side right -fill y
pack .t.log -side left -fill both -expand true
pack .t -side top -fill both -expand true

##################################################
#                                                #
#  Create the hint status line                   #
#                                                #
##################################################

frame .hintline
label .hintline.status -relief sunken -text ""
pack .hintline.status -fill x -pady 1m
pack .hintline -side top  -fill x


##################################################
#                                                #
#  Run the program and arrange to read its input #
#                                                #
##################################################

proc Run {cmd} {
	global input log 
	. config -cursor watch
	disableButtons
	if [catch {open "|newtonlink $cmd |& cat"} input] {
		$log insert end $input\n
	} else {
		fileevent $input readable Log
		$log insert end "Newtonlink $cmd\n"
	}
}

##################################################
#                                                #
#  Run the program, but ask for a file first and #
#  arrange to read its input                     #
#                                                #
##################################################

proc Runf {cmd} {
	global input log
  
	set types {
			  {{All Files}		*		}
			  {{Package Files}	{.pkg}	}
			  {{Text Files}		{.txt}	}
			  {{HTML files}		{.html}	}
			  {{Sloup Files}	{.slp}	}
			  {{Newt Files}		{.nwt}	}
			  {{Bitmap Files}	{.bit}	}
			  {{Sound File}		{.snd}	}
			  }

	
  set file [tk_getOpenFile -filetypes $types -title "Choose a File..."]
  if {$file == {}} {  
    tk_messageBox -type ok -message "You did not select a file." -icon info
	return
  }
	. config -cursor watch
	disableButtons
	if [catch {open "|newtonlink $cmd $file  |& cat"} input] {
		$log insert end $input\n
	} else {
		fileevent $input readable Log
		$log insert end "Newtonlink $cmd\n"
	}
}


##################################################
#                                                #
#  Read and log output from the program          #
#                                                #
##################################################

proc Log {} {
	global input log
	if [eof $input] {
		Stop
	} else {
#		gets $input line
		set line [read $input 1 ]
		$log insert end $line
		$log see end
	}
}

##################################################
#                                                #
#  Stop the program and fix up the button        #
#                                                #
##################################################

proc Stop {} {
	global input but
	catch {close $input}
	. configure -cursor arrow
	enableButtons

}

##################################################
#                                                #
#  enableButtons                                 #
#                                                #
##################################################

proc enableButtons {} {

	.top.update configure -state normal
	.top.fax configure -state normal
	.top.print configure -state normal
	.top.plan configure -state normal
	.top.xrolo configure -state normal
	.top.adr configure -state normal
	.top.nsmail configure -state normal
	.top.nsadr configure -state normal
	.top.webadr configure -state normal
	.top.ksendfax configure -state normal
	.top.kjots configure -state normal
	.top.xfadr configure -state normal
	.top.mail configure -state normal
	.top.inst configure -state normal
	.top.lpkg configure -state normal
	.top.getpnam configure -state normal
	.top.send configure -state normal
	.top.help configure -state normal
	.top.quit configure -state normal

	.menubar.filem configure -state normal
	.menubar.update configure -state normal
	.menubar.cards configure -state normal
	.menubar.notes configure -state normal
	.menubar.dates configure -state normal
	.menubar.outbox configure -state normal
	.menubar.mail configure -state normal
	.menubar.install configure -state normal
	.menubar.misc configure -state normal
}

##################################################
#                                                #
#  disableButtons                                #
#                                                #
##################################################

proc disableButtons {} {

	.top.update configure -state disabled
	.top.fax configure -state disabled
	.top.print configure -state disabled
	.top.plan configure -state disabled
	.top.xrolo configure -state disabled
	.top.adr configure -state disabled
	.top.nsmail configure -state disabled
	.top.nsadr configure -state disabled
	.top.webadr configure -state disabled
	.top.ksendfax configure -state disabled
	.top.kjots configure -state disabled
	.top.xfadr configure -state disabled
	.top.mail configure -state disabled
	.top.inst configure -state disabled
	.top.lpkg configure -state disabled
	.top.getpnam configure -state disabled
	.top.send configure -state disabled
	.top.help configure -state disabled
	.top.quit configure -state disabled

	.menubar.filem configure -state disabled
	.menubar.update configure -state disabled
	.menubar.cards configure -state disabled
	.menubar.notes configure -state disabled
	.menubar.dates configure -state disabled
	.menubar.outbox configure -state disabled
	.menubar.mail configure -state disabled
	.menubar.install configure -state disabled
	.menubar.misc configure -state disabled
}

##################################################
#                                                #
#  Select Preferences Box                        #
#                                                #
##################################################

proc SelectPreferences {} {

	toplevel .selectPreferences
	wm title .selectPreferences "Select Newtonlink preferences"
	label .selectPreferences.ab-label -text "Addressbook File :"
	entry .selectPreferences.ab-entry -width 20 -relief sunken -bd 2 -textvariable AddressbookFile
	pack .selectPreferences.ab-label .selectPreferences.ab-entry -side left
	set AddressbookFile home
	button .selectPreferences.ok -text OK -command exit
	pack .selectPreferences.ok -side bottom
}

##################################################
#                                                #
#  Get Packages and list                         #
#                                                #
##################################################

proc getpackage {} {

	#Run {-getpnam}
	toplevel .getpackage
	wm title .getpackage "Newtonlink - Get package"

	label .getpackage.label -text "Select Newton package to upload"
	pack .getpackage.label -side top -fill x

	listbox .getpackage.packages -relief sunken -borderwidth 2 -yscrollcommand ".getpackage.scroll set"
	pack .getpackage.packages -side left -fill both -expand 1

	scrollbar .getpackage.scroll -command ".getpackage.packages yview"
	pack .getpackage.scroll -side right -fill y

	set Datei [open /home/e1l52/.newtonlink/newtonlink.packagenames]
	while {[gets $Datei Zeile] >= 0} {
		.getpackage.packages insert end [lrange $Zeile 0 end]
	}
	close $Datei
	bind .getpackage.packages <Double-Button-1> {
		.getpackage.packages configure -background [selection get]
	}

	#button .getpackage.ok -text OK -command exit
	#pack .getpackage.ok -side bottom
}

##################################################
#                                                #
#  Box  -- produce info on tknl                  #
#                                                #
##################################################

proc aboutBox {} {
	global PREFIX
	#Reinhold Schoeb, Frank Scholz, Andrew Maier, Gerald Hofer" 

	set top [toplevel .about] 
	wm title $top "About Newtonlink"
	$top configure -background white
	set ok [button .about.ok -text "Ok" -command {destroy .about}]
	set pict_img [image create photo -file $PREFIX/icons/about.gif]
	set pict [label .about.pict -width 500 -height 400 -image $pict_img]
	pack  .about.pict .about.ok -side top

}

##################################################
#                                                #
#  Box  -- currently not implemented             #
#                                                #
##################################################

proc notImplementedBox {} {

	set notImplemented [toplevel .notImplemented] 
	wm title $notImplemented "Not implemented"
        message .notImplemented.message -width 8c -justify center -text "Sorry, option currently not implemented"
	set ok [button .notImplemented.ok -text "Ok" -command {destroy .notImplemented}]
	pack .notImplemented.message .notImplemented.ok -side top

}

